/*
* A+E Television Networks
* The History Channel
* http://www.history.com/
*
* ¬¨¬®¬¨¬© 1996-2011, A&E Television Networks, LLC. All Rights Reserved.
*
* Author: Matthew Moser
*
* SAMPLE USAGE:
* <div id='shareBarDiv'></div>
*
* <script type="text/javascript">
*
*     $('#shareBarDiv').shareBar({"contextPath": "${staticContextPath}",
*                                "shareBarSize": "large",
*                             "docLocationPath": document.location.pathname,
*                                 "docLocation": document.location,
*                                    "shareUrl": <c:choose><c:when test="${empty shareUrl}">undefined</c:when><c:otherwise>"${shareUrl}"</c:otherwise></c:choose>,
*                                  "shareTitle": <c:choose><c:when test="${empty shareTitle}">undefined</c:when><c:otherwise>"${shareTitle} @history"</c:otherwise></c:choose>,
*                               "documentTitle": document.title + " @history",
*                             "facebookLikeUrl": "http://www.facebook.com/history",
*                       "facebookRecommendUrl": <c:choose><c:when test="${empty facebook.url}">undefined</c:when><c:otherwise>"${facebook.url}"</c:otherwise></c:choose>});
* </script>
*/

(function( $ ){

    // LET'S MAKE A NAMESPACE FOR SOME FUNCTIONS.
    $.shareBar = {};

    // A HELPER FUNCTION TO OPEN A WINDOW / TAB TO A EXTERNAL SHARE URL.
    $.shareBar.sharePopupWindow = function ( eventObj ) {
        if ( eventObj ) {
            window.open(eventObj.url);
            $.shareBar.onSendDoneHandler(eventObj);
        }
    };

    // A CALLBACK FUNCTION WITHIN THE 'shareBar' NAMESPACE.
    $.shareBar.onSendDoneHandler = function( eventObj ) {
        HISTORY.trackGigyaShareBarClick(eventObj);
    };

    // A UTILITY METHOD FOR REPLACING SOME NASTY, NASTY CHARACTERS FROM STRINGS - THIS SHOULD PROBABLY BE TAKEN CARE OF ON THE 'SERVERS-SIDE' EVENTUALLY.
    $.shareBar.stringScrubber = function ( inputStr, searchAndReplaceChars ) {
        $.each(searchAndReplaceChars, function(index, value) {
            var re =new RegExp(value[0],"g");
            inputStr = inputStr.replace(re,value[1]);
        });
        return inputStr;
    };

    // A UTILITY METHOD FOR PRE-PROCESSING THE SHARE OPTIONS.
    $.shareBar.urlScrubber = function ( options ) {
        var scrubbedOptions = {};
        if ( options ) {

            $.extend( scrubbedOptions, {contextPath: options.contextPath});
            $.extend( scrubbedOptions, {shareBarSize: options.shareBarSize});
            $.extend( scrubbedOptions, {docLocationPath: options.docLocationPath});
            $.extend( scrubbedOptions, {docLocation: "http://www.history.com" + (options.docLocationPath ? options.docLocationPath : "")} );
            $.extend( scrubbedOptions, {shareUrl: (options.shareUrl ? options.shareUrl : scrubbedOptions.docLocation)} );
            $.extend( scrubbedOptions, {shareTitle: $.shareBar.stringScrubber( (options.shareTitle ? options.shareTitle : options.documentTitle) , [["'","\'"],["&mdash;","--"]] )} );
            $.extend( scrubbedOptions, {documentTitle: options.documentTitle});
            $.extend( scrubbedOptions, {facebookLikeUrl: options.facebookLikeUrl});
            $.extend( scrubbedOptions, {facebookRecommendUrl: (options.facebookRecommendUrl ? options.facebookRecommendUrl : scrubbedOptions.shareUrl)} );
            $.extend( scrubbedOptions, {emailShareUrl: (options.emailShareUrl ? options.emailShareUrl : scrubbedOptions.emailShareUrl)} );
            $.extend( scrubbedOptions, {twitterShareUrl: (options.twitterShareUrl ? options.twitterShareUrl : scrubbedOptions.twitterShareUrl)} );
            $.extend( scrubbedOptions, {googlePlusUrl: (options.googlePlusUrl ? options.googlePlusUrl : scrubbedOptions.googlePlusUrl)} );

        }
        return scrubbedOptions;

    };

    // THE SHARE BAR (GIGYA) PLUGIN FUNCTION ADDED TO THE JQUERY FUNCTION NAMESPACE.
    $.fn.shareBar = function( options ) {

        var shareBarDivId = this.attr("id");  // not really needed here since 'this' IS the div placeholder for a shareBar
        /*
        var settings = {    // DEFAULT SETTINGS.

            contextPath: "http://www.history.com/",
            shareBarSize: "large",
            docLocationPath: "",
            docLocation: "http://www.history.com/",
            shareUrl: "http://www.history.com/",
            shareTitle: "shareTitle @The History Channel",
            documentTitle: "documentTitle @history",
            facebookLikeUrl: "http://www.facebook.com/history",
            facebookRecommendUrl: "http://www.history.com/"

        };
        */
        var settings = {

            contextPath:undefined,
            shareBarSize:undefined,
            docLocationPath:undefined,
            docLocation:undefined,
            shareUrl:undefined,
            shareTitle:undefined,
            documentTitle:undefined,
            facebookLikeUrl:undefined,
            facebookRecommendUrl:undefined

        };

        if ( options ) {    // OVERRIDE THE DEFAULT SETTINGS WITH JSON 'OPTIONS'.
            $.extend( settings, $.shareBar.urlScrubber( options ) );
        }
        /*
        var settingsStr = "shareBarDivId = " + shareBarDivId
                         + "\nsettings.contextPath = " + settings.contextPath
                         + "\nsettings.shareBarSize = " + settings.shareBarSize
                         + "\nsettings.docLocationPath = " + settings.docLocationPath
                         + "\nsettings.docLocation = " + settings.docLocation
                         + "\nsettings.shareUrl = " + settings.shareUrl
                         + "\nsettings.shareTitle = " + settings.shareTitle
                         + "\nsettings.documentTitle = " + settings.documentTitle
                         + "\nsettings.facebookLikeUrl = " + settings.facebookLikeUrl
                         + "\nsettings.facebookRecommendUrl = " + settings.facebookRecommendUrl;

        console.debug("jquery.shareBar()..." + settingsStr);
        */
        // CUSTOM EMAIL SHARE TEMPLATE.
        var emailShareTemplate = "Hello,<br/><br/>Take a look at <a href=\"" + settings.shareUrl + "\">" + settings.shareTitle + "</a> on HISTORY. Also, check out more articles, videos and games at <a href=\"http://www.history.com\">History.com</a>.<br><br>$userMsg$<i>";
        var emailShareTemplate_tdih = "Hello,<br/><br/>I saw this on History.com and thought it might interest you. Take a look at <a href=\"" + settings.shareUrl + "\">" + settings.shareTitle + "</a>. Also, check out more articles, videos and games at <a href=\"http://www.history.com\">History.com</a>.<br><br>$userMsg$<i>";
        // GIGYA SPECIFIC 'UserAction' OBJECTS.
        var $default_ua = $.extend( new gigya.services.socialize.UserAction(), {linkBack:settings.shareUrl,title:settings.shareTitle + " on History.com"});
        var $fb_ua_like = $.extend( new gigya.services.socialize.UserAction(), {linkBack:settings.facebookLikeUrl,title:settings.shareTitle + " on History.com"});
        var $fb_ua_rec = $.extend( new gigya.services.socialize.UserAction(), {linkBack:settings.facebookRecommendUrl,title:settings.shareTitle + " on History.com"});

        var $default_ua_tdih = $.extend( new gigya.services.socialize.UserAction(), {linkBack:settings.shareUrl,title:settings.shareTitle + " @history"});
        var $fb_ua_like_tdih = $.extend( new gigya.services.socialize.UserAction(), {linkBack:settings.facebookLikeUrl,title:settings.shareTitle + " @history"});
        var $fb_ua_rec_tdih = $.extend( new gigya.services.socialize.UserAction(), {linkBack:settings.facebookRecommendUrl,title:settings.shareTitle + " @history"});
        // for mankind show
        var $default_ua_show_mankind_twitter = $.extend( new gigya.services.socialize.UserAction(), {linkBack:settings.twitterShareUrl,title:settings.shareTitle + " on History.com"});
        var $default_ua_show_mankind_email = $.extend( new gigya.services.socialize.UserAction(), {linkBack:settings.facebookRecommendUrl,title:settings.shareTitle + " on History.com"});
        var emailShareTemplate_show_mankind = "Hello,<br/><br/>Take a look at <a href=\"" + settings.emailShareUrl + "\">" + settings.shareTitle + "</a> on HISTORY. Also, check out more articles, videos and games at <a href=\"http://www.history.com\">History.com</a>.<br><br>$userMsg$<i>";

        // GIGYA SPECIFIC 'conf' OBJECT.
        var conf = {

           APIKey:"2_UW0gX5gvtKLDXjWgTEfiHEBblsgFeQLrMW1F79mqY6WI3AsWO9neqjVavJbTLebW",
           context: shareBarDivId

        };
        // GIGYA SPECIFIC 'params' OBJECT(s) WRAPPER. ADDITIONAL SHARE BAR SIZES/STYLE ARE ADDED HERE...
        var params = {

            "large":{userAction:$fb_ua_rec,
                     showEmailButton:"true",
                     emailBody: emailShareTemplate,
                     shareButtons:[{provider:"facebook-like", action:"recommend", url:settings.facebookRecommendUrl},
                                   {provider:"facebook-send", url:settings.facebookRecommendUrl},
                                   {provider:"google-plusone",annotation:"bubble",url:settings.facebookRecommendUrl},
                                   {provider:"Twitter",userAction:$default_ua,iconOnly:"true",enableCount:"false",iconImgUp:settings.contextPath + "/imgs/template/toolbox-tweetn.png",iconImgOver:settings.contextPath + "/imgs/template/toolbox-tweetn.png"},
                                   {provider:"Stumbleupon",userAction:$default_ua,iconOnly:"true",iconImgUp:settings.contextPath + "/imgs/template/toolbox-stumbleupon.png",iconImgOver:settings.contextPath + "/imgs/template/toolbox-stumbleupon.png"},
                                   {provider:"email",userAction:$default_ua,iconOnly:"true",iconImgUp:settings.contextPath + "/imgs/template/toolbox-email.png",iconImgOver:settings.contextPath + "/imgs/template/toolbox-email.png"}],
                     containerID: shareBarDivId,
                     cid:shareBarDivId,
                     onSendDone: $.shareBar.onSendDoneHandler},

             "large-tdih":{userAction:$fb_ua_rec_tdih,
                     showEmailButton:"true",
                     emailBody: emailShareTemplate_tdih,
                     shareButtons:[{provider:"facebook-like", action:"recommend", url:settings.facebookRecommendUrl},
                                   {provider:"facebook-send", url:settings.facebookRecommendUrl},
                                   {provider:"google-plusone",annotation:"bubble", url:settings.facebookRecommendUrl},
                                   {provider:"Twitter",userAction:$default_ua_tdih,iconOnly:"true",enableCount:"false",iconImgUp:settings.contextPath + "/imgs/template/toolbox-tweetn.png",iconImgOver:settings.contextPath + "/imgs/template/toolbox-tweetn.png"},
                                   {provider:"Stumbleupon",userAction:$default_ua_tdih,iconOnly:"true",iconImgUp:settings.contextPath + "/imgs/template/toolbox-stumbleupon.png",iconImgOver:settings.contextPath + "/imgs/template/toolbox-stumbleupon.png"},
                                   {provider:"email",userAction:$default_ua_tdih,iconOnly:"true",iconImgUp:settings.contextPath + "/imgs/template/toolbox-email.png",iconImgOver:settings.contextPath + "/imgs/template/toolbox-email.png"}],
                     containerID: shareBarDivId,
                     cid:shareBarDivId,
                     onSendDone: $.shareBar.onSendDoneHandler},

            "small":{userAction:$fb_ua_rec,
                     showEmailButton:"true",
                     emailBody: emailShareTemplate,
                     shareButtons:[{provider:"facebook-like", action:"recommend",  url:settings.facebookLikeUrl},
                                   {provider:"Twitter",userAction:$default_ua,iconOnly:"true",enableCount:"false",iconImgUp:settings.contextPath + "/imgs/template/toolbox-tweetn.png",iconImgOver:settings.contextPath + "/imgs/template/toolbox-tweetn.png"},
                                   {provider:"Stumbleupon",userAction:$default_ua,iconOnly:"true",iconImgUp:settings.contextPath + "/imgs/template/toolbox-stumbleupon.png",iconImgOver:settings.contextPath + "/imgs/template/toolbox-stumbleupon.png"},
                                   {provider:"email",userAction:$default_ua,iconOnly:"true",iconImgUp:settings.contextPath + "/imgs/template/toolbox-email.png",iconImgOver:settings.contextPath + "/imgs/template/toolbox-email.png"}],
                     containerID: shareBarDivId,
                     cid: shareBarDivId,
                     onSendDone: $.shareBar.onSendDoneHandler},

    "singletonLike":{userAction: $fb_ua_like,
                     facebookUserAction: $fb_ua_like,
                     shareButtons: [{provider:"facebook-like",enableCount:"true",position:"first", url:settings.facebookLikeUrl}],
                     containerID: shareBarDivId,
                     cid:shareBarDivId,
		             onSendDone: $.shareBar.onSendDoneHandler} ,
"large-show-mankind":{userAction:$fb_ua_rec,
                     showEmailButton:"true",
                     emailBody: emailShareTemplate_show_mankind,
                     shareButtons:[{provider:"facebook-like", action:"recommend", url:settings.facebookRecommendUrl},
                                   {provider:"facebook-send", url:settings.facebookRecommendUrl},
                                   {provider:"google-plusone",annotation:"bubble", url:settings.googlePlusUrl},
                                   {provider:"Twitter",userAction:$default_ua_show_mankind_twitter,iconOnly:"true",enableCount:"false",iconImgUp:settings.contextPath + "/imgs/template/toolbox-tweetn.png",iconImgOver:settings.contextPath + "/imgs/template/toolbox-tweetn.png"},
                                   {provider:"Stumbleupon",userAction:$default_ua,iconOnly:"true",iconImgUp:settings.contextPath + "/imgs/template/toolbox-stumbleupon.png",iconImgOver:settings.contextPath + "/imgs/template/toolbox-stumbleupon.png"},
                                   {provider:"email",userAction:$default_ua_show_mankind_email,iconOnly:"true",iconImgUp:settings.contextPath + "/imgs/template/toolbox-email.png",iconImgOver:settings.contextPath + "/imgs/template/toolbox-email.png"}],
                     containerID: shareBarDivId,
                     cid:shareBarDivId,
                     onSendDone: $.shareBar.onSendDoneHandler}

        }
        
        // GIGYA A-SYNCH JAVASCRIPT API CALL FOR CREATING A SHARE BAR.
        gigya.services.socialize.showShareBarUI(conf,params[settings.shareBarSize]);

        // DO WE REALLY NEED CHAINING HERE? PROBABLY NOT.
        //return this;

    };

})( jQuery );
